/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class XLeftRightArrowFactory {
    private static final Atom MINUS = SymbolAtom.get("minus");
    private static final Atom LEFT = SymbolAtom.get("leftarrow");
    private static final Atom RIGHT = SymbolAtom.get("rightarrow");

    public static Box create(boolean left, TeXEnvironment env, float width) {
        float w;
        Box arr = left ? LEFT.createBox(env) : RIGHT.createBox(env);
        float h = arr.getHeight();
        float d = arr.getDepth();
        float swidth = arr.getWidth();
        if (width <= swidth) {
            arr.setDepth(d / 2.0f);
            return arr;
        }
        Box minus = new SmashedAtom(MINUS, "").createBox(env);
        Box kern = new SpaceAtom(5, -4.0f, 0.0f, 0.0f).createBox(env);
        float mwidth = minus.getWidth() + kern.getWidth();
        swidth += kern.getWidth();
        HorizontalBox hb = new HorizontalBox();
        for (w = 0.0f; w < width - swidth - mwidth; w += mwidth) {
            hb.add(minus);
            hb.add(kern);
        }
        float sf = (width - swidth - w) / minus.getWidth();
        hb.add(new SpaceAtom(5, -2.0f * sf, 0.0f, 0.0f).createBox(env));
        hb.add(new ScaleAtom(MINUS, sf, 1.0).createBox(env));
        if (left) {
            hb.add(0, new SpaceAtom(5, -3.5f, 0.0f, 0.0f).createBox(env));
            hb.add(0, arr);
        } else {
            hb.add(new SpaceAtom(5, -2.0f * sf - 2.0f, 0.0f, 0.0f).createBox(env));
            hb.add(arr);
        }
        hb.setDepth(d / 2.0f);
        hb.setHeight(h);
        return hb;
    }

    public static Box create(TeXEnvironment env, float width) {
        float w;
        Box left = LEFT.createBox(env);
        Box right = RIGHT.createBox(env);
        float swidth = left.getWidth() + right.getWidth();
        if (width < swidth) {
            HorizontalBox hb = new HorizontalBox(left);
            hb.add(new StrutBox(-Math.min(swidth - width, left.getWidth()), 0.0f, 0.0f, 0.0f));
            hb.add(right);
            return hb;
        }
        Box minus = new SmashedAtom(MINUS, "").createBox(env);
        Box kern = new SpaceAtom(5, -3.4f, 0.0f, 0.0f).createBox(env);
        float mwidth = minus.getWidth() + kern.getWidth();
        swidth += 2.0f * kern.getWidth();
        HorizontalBox hb = new HorizontalBox();
        for (w = 0.0f; w < width - swidth - mwidth; w += mwidth) {
            hb.add(minus);
            hb.add(kern);
        }
        hb.add(new ScaleBox(minus, (width - swidth - w) / minus.getWidth(), 1.0));
        hb.add(0, kern);
        hb.add(0, left);
        hb.add(kern);
        hb.add(right);
        return hb;
    }
}

