/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;

public class URLCheck {
    public static boolean isURLforbidden(String full) {
        if (full.contains("@")) {
            return true;
        }
        if (!full.startsWith("https://") && !full.startsWith("http://")) {
            return true;
        }
        if (full.matches("^https?://[-#.0-9:\\[\\]+]+/.*")) {
            return true;
        }
        if (full.matches("^https?://[^.]+/.*")) {
            return true;
        }
        if (full.matches("^https?://[^.]+$")) {
            return true;
        }
        try {
            if (URLCheck.isURLforbidden(new URL(full))) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static boolean isURLforbidden(URL url) throws UnsupportedEncodingException, UnknownHostException {
        String decodedHost;
        String userInfo = url.getUserInfo();
        if (userInfo != null && !userInfo.isEmpty()) {
            return true;
        }
        String protocol = url.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return true;
        }
        String host = url.getHost();
        if (host == null || host.isEmpty() || !host.contains(".")) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() != SecurityProfile.UNSECURE) {
            if (host.matches("^[-#.0-9:\\[\\]+]+$")) {
                return true;
            }
            InetAddress inetAddress = InetAddress.getByName(host);
            if (URLCheck.isInnerAddress(inetAddress)) {
                return true;
            }
        }
        return !host.equals(decodedHost = URLDecoder.decode(host, "UTF-8"));
    }

    private static boolean isInnerAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress();
    }
}

