/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactoryManager;

public class PooledSearchEntryResolver
extends AbstractSearchEntryResolver
implements PooledConnectionFactoryManager {
    private PooledConnectionFactory factory;

    public PooledSearchEntryResolver() {
    }

    public PooledSearchEntryResolver(PooledConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    @Override
    public PooledConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(PooledConnectionFactory cf) {
        this.factory = cf;
    }

    @Override
    protected SearchResult performLdapSearch(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        try (Connection pooledConn = this.factory.getConnection();){
            SearchOperation op = this.createSearchOperation(pooledConn);
            SearchResult searchResult = (SearchResult)op.execute(this.createSearchRequest(criteria)).getResult();
            return searchResult;
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, baseDn=%s, userFilter=%s, userFilterParameters=%s, allowMultipleEntries=%s, subtreeSearch=%s, derefAliases=%s, referralHandler=%s, searchEntryHandlers=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.factory, this.getBaseDn(), this.getUserFilter(), Arrays.toString(this.getUserFilterParameters()), this.getAllowMultipleEntries(), this.getSubtreeSearch(), this.getDerefAliases(), this.getReferralHandler(), Arrays.toString(this.getSearchEntryHandlers())});
    }
}

