/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.cluster.AllocationExplainResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class AllocationExplainRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AllocationExplainRequest> {
    @Nullable
    private final String currentNode;
    @Nullable
    private final Boolean includeDiskInfo;
    @Nullable
    private final Boolean includeYesDecisions;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean primary;
    @Nullable
    private final Integer shard;
    public static final JsonpDeserializer<AllocationExplainRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationExplainRequest::setupAllocationExplainRequestDeserializer);
    public static final Endpoint<AllocationExplainRequest, AllocationExplainResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AllocationExplainRequest, AllocationExplainResponse>(request -> "POST", request -> "/_cluster/allocation/explain", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, AllocationExplainResponse._DESERIALIZER);

    private AllocationExplainRequest(Builder builder) {
        super(builder);
        this.currentNode = builder.currentNode;
        this.includeDiskInfo = builder.includeDiskInfo;
        this.includeYesDecisions = builder.includeYesDecisions;
        this.index = builder.index;
        this.primary = builder.primary;
        this.shard = builder.shard;
    }

    public static AllocationExplainRequest of(Function<Builder, ObjectBuilder<AllocationExplainRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String currentNode() {
        return this.currentNode;
    }

    @Nullable
    public final Boolean includeDiskInfo() {
        return this.includeDiskInfo;
    }

    @Nullable
    public final Boolean includeYesDecisions() {
        return this.includeYesDecisions;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean primary() {
        return this.primary;
    }

    @Nullable
    public final Integer shard() {
        return this.shard;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentNode != null) {
            generator.writeKey("current_node");
            generator.write(this.currentNode);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.primary != null) {
            generator.writeKey("primary");
            generator.write(this.primary.booleanValue());
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAllocationExplainRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentNode, JsonpDeserializer.stringDeserializer(), "current_node");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.includeDiskInfo != null) {
            params.put("include_disk_info", String.valueOf(this.includeDiskInfo));
        }
        if (this.includeYesDecisions != null) {
            params.put("include_yes_decisions", String.valueOf(this.includeYesDecisions));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.currentNode);
        result = 31 * result + Objects.hashCode(this.includeDiskInfo);
        result = 31 * result + Objects.hashCode(this.includeYesDecisions);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.primary);
        result = 31 * result + Objects.hashCode(this.shard);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllocationExplainRequest other = (AllocationExplainRequest)o;
        return Objects.equals(this.currentNode, other.currentNode) && Objects.equals(this.includeDiskInfo, other.includeDiskInfo) && Objects.equals(this.includeYesDecisions, other.includeYesDecisions) && Objects.equals(this.index, other.index) && Objects.equals(this.primary, other.primary) && Objects.equals(this.shard, other.shard);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AllocationExplainRequest> {
        @Nullable
        private String currentNode;
        @Nullable
        private Boolean includeDiskInfo;
        @Nullable
        private Boolean includeYesDecisions;
        @Nullable
        private String index;
        @Nullable
        private Boolean primary;
        @Nullable
        private Integer shard;

        public Builder() {
        }

        private Builder(AllocationExplainRequest o) {
            super(o);
            this.currentNode = o.currentNode;
            this.includeDiskInfo = o.includeDiskInfo;
            this.includeYesDecisions = o.includeYesDecisions;
            this.index = o.index;
            this.primary = o.primary;
            this.shard = o.shard;
        }

        private Builder(Builder o) {
            super(o);
            this.currentNode = o.currentNode;
            this.includeDiskInfo = o.includeDiskInfo;
            this.includeYesDecisions = o.includeYesDecisions;
            this.index = o.index;
            this.primary = o.primary;
            this.shard = o.shard;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder currentNode(@Nullable String value) {
            this.currentNode = value;
            return this;
        }

        @Nonnull
        public final Builder includeDiskInfo(@Nullable Boolean value) {
            this.includeDiskInfo = value;
            return this;
        }

        @Nonnull
        public final Builder includeYesDecisions(@Nullable Boolean value) {
            this.includeYesDecisions = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder primary(@Nullable Boolean value) {
            this.primary = value;
            return this;
        }

        @Nonnull
        public final Builder shard(@Nullable Integer value) {
            this.shard = value;
            return this;
        }

        @Override
        @Nonnull
        public AllocationExplainRequest build() {
            this._checkSingleUse();
            return new AllocationExplainRequest(this);
        }
    }
}

