/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.lucene.util.CombinedBitSet;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.approximate.ApproximateScoreQuery;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.QueryFetchSearchResult;
import org.opensearch.search.internal.CancellableBulkScorer;
import org.opensearch.search.internal.ExitableDirectoryReader;
import org.opensearch.search.internal.MaxTargetSliceSupplier;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.ProfileWeight;
import org.opensearch.search.profile.query.QueryProfiler;
import org.opensearch.search.profile.query.QueryTimingType;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.MinAndMax;
import org.opensearch.search.streaming.FlushMode;

@PublicApi(since="1.0.0")
public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private static final Logger logger = LogManager.getLogger(ContextIndexSearcher.class);
    private static final int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private MutableQueryTimeout cancellable;
    private SearchContext searchContext;

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader, Executor executor, SearchContext searchContext) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, executor, searchContext);
    }

    private ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, MutableQueryTimeout cancellable, boolean wrapWithExitableDirectoryReader, Executor executor, SearchContext searchContext) throws IOException {
        super((IndexReader)(wrapWithExitableDirectoryReader ? new ExitableDirectoryReader((DirectoryReader)reader, cancellable) : reader), executor);
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
        this.cancellable = cancellable;
        this.searchContext = searchContext;
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public QueryProfiler getProfiler() {
        return this.profiler;
    }

    public Runnable addQueryCancellation(Runnable action) {
        return this.cancellable.add(action);
    }

    public void removeQueryCancellation(Runnable action) {
        this.cancellable.remove(action);
    }

    public void close() {
        this.cancellable.clear();
    }

    public boolean hasCancellations() {
        return this.cancellable.isEnabled();
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (original instanceof ApproximateScoreQuery) {
            ((ApproximateScoreQuery)original).setContext(this.searchContext);
        }
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            ContextualProfileBreakdown profile = (ContextualProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = query.createWeight((IndexSearcher)this, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    public void search(List<LeafReaderContext> leaves, Weight weight, CollectorManager manager, QuerySearchResult result, DocValueFormat[] formats, TotalHits totalHits) throws IOException {
        ArrayList<Collector> collectors = new ArrayList<Collector>(leaves.size());
        for (LeafReaderContext ctx : leaves) {
            Collector collector = manager.newCollector();
            this.searchLeaf(ctx, 0, Integer.MAX_VALUE, weight, collector);
            collectors.add(collector);
        }
        TopFieldDocs mergedTopDocs = (TopFieldDocs)manager.reduce(collectors);
        for (ScoreDoc scoreDoc : mergedTopDocs.scoreDocs) {
            scoreDoc.shardIndex = -1;
        }
        if (totalHits != null) {
            mergedTopDocs = new TopFieldDocs(totalHits, mergedTopDocs.scoreDocs, mergedTopDocs.fields);
        }
        result.topDocs(new TopDocsAndMaxScore((TopDocs)mergedTopDocs, Float.NaN), formats);
    }

    public void search(Query query, Collector collector) throws IOException {
        query = collector.scoreMode().needsScores() ? this.rewrite(query) : this.rewrite((Query)new ConstantScoreQuery(query));
        Weight weight = this.createWeight(query, collector.scoreMode(), 1.0f);
        IndexSearcher.LeafReaderContextPartition[] partitions = this.getLeafContexts() == null ? new IndexSearcher.LeafReaderContextPartition[]{} : (IndexSearcher.LeafReaderContextPartition[])this.getLeafContexts().stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).toArray(IndexSearcher.LeafReaderContextPartition[]::new);
        this.search(partitions, weight, collector);
    }

    public void search(Query query, CollectorManager<?, TopFieldDocs> manager, QuerySearchResult result, DocValueFormat[] formats, TotalHits totalHits) throws IOException {
        TopFieldDocs mergedTopDocs = (TopFieldDocs)this.search(query, manager);
        for (ScoreDoc scoreDoc : mergedTopDocs.scoreDocs) {
            scoreDoc.shardIndex = -1;
        }
        if (totalHits != null) {
            mergedTopDocs = new TopFieldDocs(totalHits, mergedTopDocs.scoreDocs, mergedTopDocs.fields);
        }
        result.topDocs(new TopDocsAndMaxScore((TopDocs)mergedTopDocs, Float.NaN), formats);
    }

    protected void search(IndexSearcher.LeafReaderContextPartition[] partitions, Weight weight, Collector collector) throws IOException {
        this.searchContext.indexShard().getSearchOperationListener().onPreSliceExecution(this.searchContext);
        try {
            if (this.searchContext.shouldUseTimeSeriesDescSortOptimization()) {
                for (int i = partitions.length - 1; i >= 0; --i) {
                    this.searchLeaf(partitions[i].ctx, partitions[i].minDocId, partitions[i].maxDocId, weight, collector);
                }
            } else {
                for (IndexSearcher.LeafReaderContextPartition partition : partitions) {
                    this.searchLeaf(partition.ctx, partition.minDocId, partition.maxDocId, weight, collector);
                }
            }
            this.searchContext.bucketCollectorProcessor().processPostCollection(collector);
        }
        catch (Throwable t) {
            this.searchContext.indexShard().getSearchOperationListener().onFailedSliceExecution(this.searchContext);
            throw t;
        }
        this.searchContext.indexShard().getSearchOperationListener().onSliceExecution(this.searchContext);
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        if (!this.canMatch(ctx)) {
            return;
        }
        try {
            this.cancellable.checkCancelled();
            if (weight instanceof ProfileWeight) {
                ((ProfileWeight)weight).associateCollectorToLeaves(ctx, collector);
            }
            weight = this.wrapWeight(weight);
            collector.setWeight(weight);
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        catch (QueryPhase.TimeExceededException e) {
            this.searchContext.setSearchTimedOut(true);
            return;
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        BitSet liveDocsBitSet = ContextIndexSearcher.getSparseBitSetOrNull(liveDocs);
        if (liveDocsBitSet == null) {
            BulkScorer bulkScorer = weight.bulkScorer(ctx);
            if (bulkScorer != null) {
                try {
                    bulkScorer.score(leafCollector, liveDocs, minDocId, maxDocId);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {
                }
                catch (QueryPhase.TimeExceededException e) {
                    this.searchContext.setSearchTimedOut(true);
                    return;
                }
            }
        } else {
            Scorer scorer = weight.scorer(ctx);
            if (scorer != null) {
                try {
                    ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocsBitSet, leafCollector, minDocId, maxDocId, this.cancellable.isEnabled() ? this.cancellable::checkCancelled : () -> {});
                }
                catch (CollectionTerminatedException e) {
                }
                catch (QueryPhase.TimeExceededException e) {
                    this.searchContext.setSearchTimedOut(true);
                    return;
                }
            }
        }
        if (this.searchContext.isStreamSearch() && this.searchContext.getFlushMode() == FlushMode.PER_SEGMENT) {
            logger.debug("Stream intermediate aggregation for segment [{}], shard [{}]", (Object)ctx.ord, (Object)this.searchContext.shardTarget().getShardId().id());
            List<InternalAggregation> internalAggregation = this.searchContext.bucketCollectorProcessor().buildAggBatch(collector);
            if (!internalAggregation.isEmpty()) {
                this.sendBatch(internalAggregation);
            }
        }
        leafCollector.finish();
    }

    void sendBatch(List<InternalAggregation> batch) {
        InternalAggregations batchAggResult = new InternalAggregations(batch);
        QuerySearchResult queryResult = this.searchContext.queryResult();
        QuerySearchResult cloneResult = new QuerySearchResult(queryResult.getContextId(), queryResult.getSearchShardTarget(), queryResult.getShardSearchRequest());
        cloneResult.aggregations(batchAggResult);
        cloneResult.topDocs(new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN), new DocValueFormat[0]);
        FetchSearchResult fetchResult = this.searchContext.fetchResult();
        fetchResult.hits(SearchHits.empty());
        QueryFetchSearchResult result = new QueryFetchSearchResult(cloneResult, fetchResult);
        this.searchContext.getStreamChannelListener().onStreamResponse(result, false);
    }

    private Weight wrapWeight(final Weight weight) {
        if (this.cancellable.isEnabled()) {
            return new Weight(weight.getQuery()){

                public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    throw new UnsupportedOperationException();
                }

                public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                    return new ScorerSupplier(){
                        private Scorer scorer;
                        private BulkScorer bulkScorer;

                        public Scorer get(long leadCost) throws IOException {
                            this.scorer = weight.scorer(context);
                            return this.scorer;
                        }

                        public BulkScorer bulkScorer() throws IOException {
                            BulkScorer in = weight.bulkScorer(context);
                            this.bulkScorer = in != null ? new CancellableBulkScorer(in, ContextIndexSearcher.this.cancellable::checkCancelled) : null;
                            return this.bulkScorer;
                        }

                        public long cost() {
                            if (this.scorer != null) {
                                return this.scorer.iterator().cost();
                            }
                            if (this.bulkScorer != null) {
                                return this.bulkScorer.cost();
                            }
                            return Integer.MAX_VALUE;
                        }
                    };
                }

                public int count(LeafReaderContext context) throws IOException {
                    return weight.count(context);
                }
            };
        }
        return weight;
    }

    private static BitSet getSparseBitSetOrNull(Bits liveDocs) {
        if (liveDocs instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        if (liveDocs instanceof CombinedBitSet && ((CombinedBitSet)liveDocs).getFirst() instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        return null;
    }

    static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        ContextIndexSearcher.intersectScorerAndBitSet(scorer, acceptDocs, collector, 0, Integer.MAX_VALUE, checkCancelled);
    }

    private static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, int minDocId, int maxDocId, Runnable checkCancelled) throws IOException {
        collector.setScorer((Scorable)scorer);
        DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(new BitSetIterator(acceptDocs, (long)acceptDocs.approximateCardinality()), scorer.iterator()));
        int seen = 0;
        checkCancelled.run();
        iterator.advance(minDocId);
        int docId = iterator.docID();
        while (docId < maxDocId) {
            if (++seen % 2048 == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return this.slicesInternal(leaves, this.searchContext.getTargetMaxSliceCount());
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + String.valueOf(reader.getClass());
        return (DirectoryReader)reader;
    }

    private boolean canMatch(LeafReaderContext ctx) throws IOException {
        return this.canMatchSearchAfter(ctx);
    }

    private boolean canMatchSearchAfter(LeafReaderContext ctx) throws IOException {
        FieldSortBuilder primarySortField;
        if (this.searchContext.searchAfter() != null && this.searchContext.request() != null && this.searchContext.request().source() != null && (primarySortField = FieldSortBuilder.getPrimaryFieldSortOrNull(this.searchContext.request().source())) != null) {
            MinAndMax<?> minMax = FieldSortBuilder.getMinMaxOrNullForSegment(this.searchContext.getQueryShardContext(), ctx, primarySortField, this.searchContext.sort());
            return SearchService.canMatchSearchAfter(this.searchContext.searchAfter(), minMax, primarySortField, this.searchContext.trackTotalHitsUpTo());
        }
        return true;
    }

    IndexSearcher.LeafSlice[] slicesInternal(List<LeafReaderContext> leaves, int targetMaxSlice) {
        IndexSearcher.LeafSlice[] leafSlices;
        if (targetMaxSlice == 0) {
            leafSlices = super.slices(leaves);
            logger.debug("Slice count using lucene default [{}]", (Object)leafSlices.length);
        } else {
            leafSlices = MaxTargetSliceSupplier.getSlices(leaves, targetMaxSlice);
            logger.debug("Slice count using max target slice supplier [{}]", (Object)leafSlices.length);
        }
        return leafSlices;
    }

    private static class MutableQueryTimeout
    implements ExitableDirectoryReader.QueryCancellation {
        private final Set<Runnable> runnables = new HashSet<Runnable>();

        private MutableQueryTimeout() {
        }

        private Runnable add(Runnable action) {
            Objects.requireNonNull(action, "cancellation runnable should not be null");
            if (!this.runnables.add(action)) {
                throw new IllegalArgumentException("Cancellation runnable already added");
            }
            return action;
        }

        private void remove(Runnable action) {
            this.runnables.remove(action);
        }

        @Override
        public void checkCancelled() {
            for (Runnable timeout : this.runnables) {
                timeout.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.runnables.isEmpty();
        }

        public void clear() {
            this.runnables.clear();
        }
    }
}

