/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmEvery<T>
extends AbstractSqmExpression<T> {
    private final SqmSubQuery<T> subquery;

    public SqmEvery(SqmSubQuery<T> subquery, NodeBuilder criteriaBuilder) {
        super(subquery.getNodeType(), criteriaBuilder);
        this.subquery = subquery;
    }

    @Override
    public @Nullable SqmBindableType<T> getNodeType() {
        return this.subquery.getNodeType();
    }

    @Override
    public Integer getTupleLength() {
        return this.subquery.getTupleLength();
    }

    @Override
    public SqmEvery<T> copy(SqmCopyContext context) {
        SqmEvery existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEvery<T> expression = context.registerCopy(this, new SqmEvery<T>(this.subquery.copy(context), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmSubQuery<T> getSubquery() {
        return this.subquery;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEvery(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("all ");
        this.subquery.appendHqlString(hql, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmEvery)) return false;
        SqmEvery sqmAny = (SqmEvery)object;
        if (!Objects.equals(this.subquery, sqmAny.subquery)) return false;
        return true;
    }

    public int hashCode() {
        return this.subquery.hashCode();
    }
}

