/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;

class RawUnixDESCryptPassword
extends RawPassword
implements UnixDESCryptPassword {
    private static final long serialVersionUID = -450182335481921391L;
    private final short salt;
    private final byte[] hash;

    RawUnixDESCryptPassword(String algorithm, short salt, byte[] hash) {
        super(algorithm);
        this.salt = salt;
        this.hash = hash;
    }

    @Override
    public short getSalt() {
        return this.salt;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public RawUnixDESCryptPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)Arrays.hashCode(this.hash), (int)this.salt);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawUnixDESCryptPassword)) {
            return false;
        }
        RawUnixDESCryptPassword other = (RawUnixDESCryptPassword)obj;
        return this.salt == other.salt && Arrays.equals(this.hash, other.hash);
    }
}

