/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.TextUtil;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(InternalProblem problem) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, true);
    }

    public static String renderMinimalInformationAbout(InternalProblem problem, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(InternalProblem problem, boolean renderDocLink, boolean renderSolutions) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TextUtil.endLineWithDot((String)Optional.ofNullable(problem.getContextualLabel()).orElseGet(() -> problem.getDefinition().getId().getDisplayName())));
        Optional.ofNullable(problem.getDetails()).ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)problem.getDetails())));
        });
        if (renderSolutions) {
            ArrayList<String> allSolutions = new ArrayList<String>(problem.getSolutions().size() + problem.getSolutions().size());
            allSolutions.addAll(problem.getSolutions());
            TypeValidationProblemRenderer.renderSolutions(formatter, allSolutions);
        }
        if (renderDocLink) {
            Optional.ofNullable(problem.getDefinition().getDocumentationLink()).ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node(new DocumentationRegistry().getDocumentationRecommendationFor("information", docLink));
            });
        }
        return formatter.toString();
    }

    public static void renderSolutions(TreeFormatter formatter, List<String> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)possibleSolutions.get(0))));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot((String)solution))));
                formatter.endChildren();
            }
        }
    }

    public static String convertToSingleLine(String message) {
        return message.replaceAll("(\\r?\\n *)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }
}

